/**
 * UI utilities
 * 
 * @class UI
 * @static
 */
Application.UI = {
	/**
	 * Based on http://ejohn.org/blog/javascript-micro-templating/ John Resig -
	 * http://ejohn.org/ - MIT Licensed
	 * 
	 * @method _compileTmpl
	 * @private
	 * @param {String}
	 *            tmpl
	 * @return {Function}
	 */
	_compileTmpl : function(tmpl) {
		return new Function("obj", "var p=[];"
				+ "with(obj){p.push('"
				+ tmpl.replace(/[\r\t\n]/g, " ").split("<%").join("\t")
						.replace(/((^|%>)[^\t]*)'/g, "$1\r").replace(
								/\t=(.*?)%>/g, "',$1,'").split("\t")
						.join("');").split("%>").join("p.push('").split("\r")
						.join("\\'") + "');}return p.join('');");
	},
	renderTmpl : function(tmpl, context) {
		return this._compileTmpl(tmpl)(context);
	},
	
	/**
	 * if element el does not fit on the visible part of the list, move scroll up or down so that whole element fit in viewbox
	 * @method scrollList
	 * @param {object} el: html element on the list 
	 * @param {String} cnt_id: id of the list
	 * */
	scrollList : function(el,cnt_id){
		var elem = el,
			container = document.getElementById(cnt_id), 
			scrollTop = container.scrollTop,
			offsetTop = container.findPos().y,
			viewportHeight = container.offsetHeight,
			pos = elem.findPos(), 
			height = elem.offsetHeight;

		pos.y = pos.y - offsetTop;
		if( pos.y + height > viewportHeight + scrollTop ){
			container.scrollTop = ( pos.y + height ) - viewportHeight + 25;
		}
		if(scrollTop > pos.y){
			container.scrollTop = pos.y-25;	
		}
		var fakes = container.getElementsByClassName('fake'),
		fakeUp = fakes ? fakes[0] : null,
			fakeDown = fakes ? fakes[1] : null;
			
		if( container.scrollTop == 0 ){
			if( fakeUp ) fakeUp.addClass('disabled'); 
		} else {
			if( fakeUp ) fakeUp.removeClass('disabled');
		}
		if( container.scrollHeight > container.offsetHeight + container.scrollTop ){
			if( fakeDown ) fakeDown.removeClass('disabled');
		} else {
			if( fakeDown ) fakeDown.addClass('disabled');
		}
	},
	/**
	 * enable Keyboard navigation 
	 * document.moveFocus[Right,Left,Up,Down] must be supported
	 * */
	bindNav: function(){
		if(!document.moveFocusRight) return;
		document.onkeypress = function(e){
			if (!e) e=window.event;
			if (37 <= e.keyCode && e.keyCode <= 40) {
				e.preventDefault();
				e.stopPropagation();
				switch (e.keyCode) {
		            case 39:
		                document.moveFocusRight();
		                break;
		            case 37:
		            	document.moveFocusLeft();
		                break;
		            case 40:
		            	document.moveFocusDown();
		                break;
		            case 38:
		            	document.moveFocusUp();
		                break;
		        }
		    }
		}; 
	}
};
/**
 * object responsible for box with content of active item
 * activates (if necessary) navigation arrows up and down
 * replaces content on item focus
 * */
Application.UI.active = {
	init : function() {
		this.el = document.getElementById('active_item');
		this.cnt = this.el.querySelector('#active_content');
		this.nav.init();
	},
	nav : {
		init : function() {
			this.el = document.getElementById('arrow_down');
			this.down = this.el.querySelector('.down');
			this.up = this.el.querySelector('.up');
			this.cnt = document.getElementById('active_content');
			
			var that = this;
			this.el.addEventListener( 'focus', function(e){
				e.preventDefault();
				e.stopPropagation();
				setTimeout(function(){that.clickDown();},100);
			}, false );
			this.el.addEventListener( 'keypress', function(e){
				if (!e) e=window.event;
			    switch(e.keyCode) {
			    	//move UP
			    	case 38:
			    		if(that.up.hasClass('disabled')) return;
		    		  	e.preventDefault();
		    		  	e.stopPropagation();
				    	that.clickUp();
				    	break;
				    //move DOWN
			    	case 40:
			    	  if(that.down.hasClass('disabled')) return;
			    	  e.preventDefault();
			    	  e.stopPropagation();
			    	  that.clickDown();
			    	  break;
			    }
			}, false );
		},
		
		enable : function() { 
			this.el.removeClass('hidden'); 
			this.arrowsRefresh();},
		disable : function() { 
			this.el.addClass('hidden');
		},
		clickUp : function() {
			if( this.up.hasClass('disabled') ) return;
			this.up.addClass('clicked');
			var that = this;
			setTimeout(function(){that.up.removeClass('clicked')},300);
	    	this.scrollUp();
		},
		clickDown : function() {
			if(this.down.hasClass('disabled')) return;
			this.down.addClass('clicked');
			var that = this;
			setTimeout(function(){that.down.removeClass('clicked')},300);
			this.scrollDown();			
		},
		arrowsRefresh : function(){
			if( this.cnt.scrollHeight == this.cnt.clientHeight+this.cnt.scrollTop ){ 
				this.down.addClass('disabled');
			}
		    else {
		    	this.down.removeClass('disabled');
	    	}
		    if( this.cnt.scrollTop == 0 ){
		    	this.up.addClass('disabled');
	    	}
		    else {
		    	this.up.removeClass('disabled');
	    	}
		},
		scrollUp : function(val) {
			this.cnt.scrollTop = ( val == undefined ? this.cnt.scrollTop-this.cnt.clientHeight/3 : val );
			this.arrowsRefresh();
		},
		scrollDown : function() {
			this.cnt.scrollTop += this.cnt.clientHeight/3;
			this.arrowsRefresh();
		}
	},
	replaceContent : function(el){
		var cnt = el.cnt;
		this.cnt.clear();
		this.cnt.appendChild(cnt);
		var tmpCnt = document.getElementById('active_content');
		var isScroll = tmpCnt.clientHeight < tmpCnt.scrollHeight ;
		if( isScroll ) {
			this.nav.enable();
		} else {
			this.nav.disable();
		}
		this.cnt.querySelector('#openItem').setNav('#updateBtn',(isScroll?'#arrow_down':'#openItem'),(isScroll?'#arrow_down':'#openItem'), '#'+el.id);
	}

};